# to autoload this file
proc m2Bindings.tcl {} {}


#===========================================================================
#  M2 KEY BINDINGS  #
#===========================================================================
# <s> stands for Shift   (<U see menu)
# <z> stands for Control (<B see menu)
# <o> stands for Option  (<I see menu)
# <c> stands for Command (<O see menu)
# Use menu Utils > Ascii Etc > Key Code to learn the coding of a particular key
 
# Global, basic M2 bindings needed at all times to open work object and launching
# Need to be active even if no file with M2 specific extensions is currently open!
# --------------------------------------------------------------------------------

namespace eval M2 {}

# --------------------------------------------------------------------------------
#  M2 Global KEY BINDINGS  #
# --------------------------------------------------------------------------------

proc M2::setGlobalBindings {} {
    # Open current set of Modula-2 working files, the ones latest compiled 
    # in case the compiler errors detected errors. Otherwise open just the last compiled. 
    # (Ctrl^0)
    Bind '0'  <z> M2::openWorkFiles
    # Launch the Modula-2 shell as configured (M2modeVars(m2_shellName) or M2ShellName)
    # Plus send it a high level event to launch a simulation (recognized by Mini RAMSES Shell)
    Bind '1'  <z> launchShellAndSimulate
    # Launch the Modula-2 shell as configured (M2modeVars(m2_shellName) or M2ShellName) without sending any events
    Bind '2'  <z> launchShell
}

M2::setGlobalBindings

proc M2::unsetGlobalBindings {} {
    unBind '0'  <z> M2::openWorkFiles
    unBind '1'  <z> launchShellAndSimulate
    unBind '2'  <z> launchShell
}



# --------------------------------------------------------------------------------
#  M2 Mode specific  bindings  #
# --------------------------------------------------------------------------------
# Search next temporary mark which points at the location where the compiler detected an error 
Bind 'e' <z> findNextError        "M2"
# Give help
Bind  Help    m2Help              "M2"
# Open corresponding module if it is a definition or implementation module (Ctrl^Option^o)
Bind 'o' <oz> openOtherLibModule     "M2"


# Break line and indent remainder  (RET) 
# Don't bind plain Return key, thus rename 
# proc breakLineAndIndent to M2::carriageReturn
# Old binding was:
# bind 0x24     breakLineAndIndent "M2"
    
#  RET key bindings  #
# 
# Break line (Ctrl^Shift^RET)
Bind 0x24 <sz> breakTheLine        	 "M2"
# Jump out of current line, return, and indent (Shift^RET)
Bind 0x24 <s> jumpOutOfLnAndReturn   "M2"
# Jump out of current line and return WITHOUT indent (Cmd^RET) (see also Shift^RET)
Bind 0x24 <c> jumpOutOfLnAndRet      "M2"
# Jump out of line and open a new line above current (Cmd^Shift^RET)
Bind 0x24 <sc> openNewAbove          "M2"  
# Jump out of line, skip next and open a new line after it (Cmd^Shift^Ctrl^RET)
Bind 0x24 <szc> skipLnReturn         "M2"  
# Jump out of line, skip previous and make a new line above it (not in use)
	# bind 0x24 <szc> skipPrevLnOpenNew    "M2"  
# Move cursor to next autostop (like TAB) or jump out of current line, return, and indent (Shift^RET)  (not in use)
	# bind 0x24 <s> tabOrJumpOutOfLnAndReturn "M2"
# Jump back to position before last jump, e.g. by JumpOutOfLnAndReturn  (Ctrl^RET)
Bind 0x24 <z> resumeBeforeCarRet     "M2"
# New line and move one line down  (Opt^RET)
Bind 0x24 <o> newLnAtSameCol         "M2"

#  TAB key bindings  #
# 
# Indent current line like closest non-white line above (Ctrl^Shift^Tab)
Bind 0x30 <sz> adjCurLnToIndentAbove "M2"
# Indent current line like closest non-white line below (Cmd^Shift^Tab)
Bind 0x30 <sc> adjCurLnToIndentBelow "M2"
# Force the insertion of an indentation even if there are still some bullets further down (Opt^Tab)
Bind 0x30 <o> modulaTab          	 "M2"
# Trigger completion (Cmd^TAB same as ESC space bar)
Bind 0x30 <c> expandSpace         "M2"
# Complete previous word (Cmd^Opt^TAB)
Bind 0x30 <oc> completePrevWord   "M2"
# Indent current line or jump to next bullet (Tab)
Bind 0x30     tabKey              "M2"
# Unindent current line (Shift^Tab)
Bind 0x30 <s> unIndent            "M2"
# Insert and actual TAB - refrain from using this in M2 Mode (Ctrl^Opt^Tab)
Bind 0x30 <zo> insertActualTab    "M2"

#  ESC key bindings  #
# Trigger completion (ESC space bar; same as Cmd^TAB)
Bind 0x31 <e> expandSpace         "M2"
# Space bar (triggers template if preceeding word matches a reserved word)
Bind 0x31     modulaSpace         "M2" 

#  Backspace and Delete key bindings  #
# 
# Delete entire line (Ctrl^BS) 
Bind 0x33 <z> killWholeLine       "M2"
# Clear line from cursor till end (Opt^BS)
Bind 0x33 <o> killLine            "M2"
# Delete next char 
Bind  Del     deleteChar          "M2"

#  Cursor key bindings  #
# 
# Select entire line in which cursor is in
Bind Down <sz> selectLine         "M2"
# Home
Bind Home <z> beginningOfBuffer   "M2"
# end
Bind End  <z> endOfBuffer         "M2"
# Cursor Right
Bind Right <z> forwardWord        "M2"
# Cursor Left
Bind Left <z> backwardWord        "M2"

#  Structural marks  #
# 
# Generate a structural mark from current selection, rest of line discarded (Ctrl^3)
Bind 0x14 <z> M2::insertDivider   "M2"
# Generate a section mark from current selection, rest of line discarded (Ctrl^4)
Bind 0x15 <z> M2::insertSubDivider   "M2"

#  Alphanumerical & special char key bindings  #
# 
# Join current line with next and reduce all white space to a single space (Ctrl^j)
Bind 'j'  <z> JoinToOneSpace	  "M2"
# Reduce white space surrounding current position to a single space (Ctrl^m)
Bind 'm'  <z> oneSpace            "M2"
# Go to next M2 place holder of form (*.  .*)
Bind 'g'  <z> nextPlaceholder     "M2"
# Go to previous M2 place holder of form (*.  .*)
Bind 'g' <sz> prevPlaceholder     "M2"
# Go to previous M2 place holder of form (*.  .*)
Bind 'g' <oz> prevPlaceholder     "M2"
# Indent by m2_indentAmount of spaces (configurable)
Bind '\]' <o> doM2ShiftRight	  "M2"
# Indent by m2_indentAmount of spaces (configurable)
Bind 'r'  <z> doM2ShiftRight      "M2"
# Unindent by m2_indentAmount of spaces (configurable)
Bind '\[' <o> doM2ShiftLeft	      "M2"
# Unindent by m2_indentAmount of spaces (configurable)
Bind 'l'  <z> doM2ShiftLeft	      "M2"
# Select comment (if present) surrounding position
Bind 's' <sz> selectM2Comment     "M2"
# Enclose (comment) selected text with prefix and suffix strings
Bind 'c'  <z> encloseSelection    "M2"
# Unenclose (uncomment) selected text from prefix and suffix strings
Bind 'c' <sz> unencloseSelection  "M2"
Bind 'c' <oz> unencloseSelection  "M2"
# Comment selected text to form (*. .*), a M2 place holder results
Bind 'k'  <z> commentSelection    "M2"
# Uncomment selected text of form (*. .*)
Bind 'k' <sz> uncommentSelection  "M2"
Bind 'k' <oz> uncommentSelection  "M2"
# Wrap text: left margin given by top line and with right margin at m2_fillRightMargin (configurable)
Bind 'a' <sz> wrapText            "M2"
# Wrap entire Modula-2 comment surrounding selection
Bind 'a' <z>  wrapComment         "M2"
# Enclose selection with " "
Bind '2' <co> {return [myWrapObject "\"" "\""]}     "M2"
# Enclose selection with ' '
Bind '2' <cos> {return [myWrapObject "'" "'"]}      "M2"
# List directory conent in new window
Bind 'f' <osz> listDirContent     "M2"
# Auto edit conditional compilation flags for a target platform
Bind 'f' <sc> autoEditCompilerFlags    "M2"


# Global bindings of use not only for M2 mode but also generally useful
# --------------------------------------------------------------------------------
# Show full path and name of currently active window in status bar (Cmd^Opt^N)
Bind 'n' <co>  showFullName


# Overrule proc uncommentLine from textManip.tcl, since it does not call removeSuffix
# as is necessary in Modula-2 (bug in Alpha <= 7.1b2) (Cmd^Opt^D, as shown in menu)
Bind 'd' <co> M2::uncommentLine   "M2"





# Reporting that end of this script has been reached
message "m2Bindings.tcl for Programing in Modula-2 loaded"
if {$installDebugFlag} then {
	alertnote "m2Bindings.tcl for Programing in Modula-2 loaded"
}
